#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <cstdio>
#include <utility> 
#include <queue>
#include <math.h>
#include <set>
#include <bitset>
#include <cmath>
#include <bitset>
#include <stack>
#include <cstring>
#include <math.h>
#include <iomanip>
#include <unordered_map>
#include <random>
#include<fstream>
#include<chrono>
using namespace std;
using namespace std::chrono;
typedef long long ll;
typedef pair<ll, ll> pii;

const int N = 4847581; // number of vertices
int inS[N + 10]; // 0 if in S, 1 if not
int inT[N + 10]; // 0 if in T, 1 if not
vector<pii> full_stream;
// General datasets
string dataset[5] = {"slash", "berkeley", "google", "pokec", "live"};
int vertices[5] = {82168, 685231, 916428, 1632804, 4847571};

vector<ll> durations;
auto global_start=high_resolution_clock::now();
double bahmaniAlg(double c, double ep, vector<pii> &stream, double s, double t, int n) {
	double S = s; // size of set S
	double T = t; // size of set T
	double totEdges = stream.size();
	double bestD = totEdges/sqrt(s * t); // best density so far
	
	vector<int> inDeg(n);
	vector<int> outDeg(n);
	while(S != 0 && T != 0) {
		if((double)S/(double)T >= c) {
			double avgD = totEdges/S;
			// Calculate out degree of each vertex
			for(pii e : stream) {
				if(inS[e.first] == 0 && inT[e.second] == 0)
					outDeg[e.first]++;
			}

			// Peeling
			for(int i = 0; i < n; i++) {
				if(inS[i] == 0 && outDeg[i] <= (1+ep)*avgD) {
					// Remove from set S
					inS[i] = 1;
					S--;
					totEdges -= outDeg[i];
				}
			}

			// Clear out degree for next iteration
			for(int i = 0; i < n; i++)
				outDeg[i] = 0;
		}
		else {
			double avgD = totEdges/T;
			// Calculate in degree of each vertex
			for(pii e : stream) {
				if(inS[e.first] == 0 && inT[e.second] == 0)
					inDeg[e.second]++;
			}

			// Peeling
			for(int i = 0; i < n; i++) {
				if(inT[i] == 0 && inDeg[i] <= (1+ep)*avgD) {
					// Remove from set T
					inT[i] = 1;
					T--;
					totEdges -= inDeg[i];
				}
			}

			// Clear out degree for next iteration
			for(int i = 0; i < n; i++)
				inDeg[i] = 0;
		}

		// Update best density
		totEdges = 0;
		for(pii e : stream) {
			if(inS[e.first] == 0 && inT[e.second] == 0)
				totEdges++;
		}
		if(S != 0 && T != 0) bestD = max(bestD, totEdges/sqrt(S*T));
	}
	return bestD;
}

double randd() {
	return (double)rand()/(double)RAND_MAX;
}

void updateTime(int i) {
	auto stop=high_resolution_clock::now();
	auto duration= duration_cast<microseconds>(stop - global_start);
	int id = i / 10000 - 1;
	if((int)durations.size() <= id) durations.push_back(duration.count());
	else durations[id] += duration.count();
	global_start=high_resolution_clock::now();
}

int curr = 0; // current location in stream
vector<pii> sssample(vector<pii> &E, double p, int s) {
	vector<pii> H;
	for(pii e : E) {
		if(randd() <= p && inS[e.first] == 0 && inT[e.second] == 0) 
			H.push_back(e);
	}
	default_random_engine gen;
    binomial_distribution<int> distr(s,p);
    int x = distr(gen);
    while(x > 0 && curr < (int)full_stream.size()) {
    	pii e = full_stream[curr];
    	if(inS[e.first] == 0 && inT[e.second] == 0) {
    		H.push_back(e);
    		E.push_back(e);
    		x--;
    	}
    	if(curr % 10000 == 0 && curr > 0) updateTime(curr);
    	curr++;
    }
    return H;
}

double ourAlg(double c, double ep, double thres, int n) {
	double S = n; // size of set S
	double T = n; // size of set T
	double totEdges = full_stream.size();
	double bestD = totEdges/(double)n; // best density so far
	// corresponding best sets S and T
	vector<int> bestS(n);
	vector<int> bestT(n);

	vector<int> inDeg(n);
	vector<int> outDeg(n);

	vector<pii> E;
	global_start=high_resolution_clock::now();
	while(S != 0 && T != 0) {
		double s = (int)full_stream.size() - curr;
		double approx = 0; // s'
		vector<pii> A;
		double var = n*log2(n)/(ep*ep*thres); // THRESHOLD
		int numEdges = round(var);
		int E_AST = 0;
		int num = min((int)full_stream.size(), curr + numEdges);
		for(int i = curr; i < num; i++) {
			pii e = full_stream[i];
			A.push_back(e);
			if(inS[e.first] == 0 && inT[e.second] == 0) E_AST++;
			if(i % 10000 == 0 && i > 0) updateTime(i);
		}
		curr = num;
		int EA = A.size();
		//cout << E_AST << ' ' << EA << ' ' << numEdges << '\n';
		if(E_AST >= 2*var/n && EA == numEdges) {
			approx = s*(1-ep)*E_AST/(double)EA + (int)E.size();
		}
		else {
			vector<pii> temp;
			for(pii e : E)
				if(inS[e.first] == 0 && inT[e.second] == 0)
					temp.push_back(e);
			for(pii e : A) { // E_A(S, T)
				if(inS[e.first] == 0 && inT[e.second] == 0)
					temp.push_back(e);
			}
			for(int i = curr; i < full_stream.size(); i++) { // Rest of stream
				if(inS[full_stream[i].first] == 0 && inT[full_stream[i].second] == 0)
					temp.push_back(full_stream[i]);
				if(i % 10000 == 0 && i > 0) updateTime(i);
			}
			double bahmaniD = 0;
			if(S > 0 && T > 0) bahmaniD = bahmaniAlg(c, ep, temp, S, T, n);
			if(bahmaniD > bestD) return bahmaniD;
			break;
		}
		cout << "************************************sampling****************************************\n";
		for(pii e : A) { // E_A(S, T)
			if(inS[e.first] == 0 && inT[e.second] == 0)
				E.push_back(e);
		}
		double p = min((double)numEdges/((1-ep)*approx), (double)1);
		vector<pii> H = sssample(E, p, round(approx - (int)E.size()));

		totEdges = H.size();
		if((double)S/(double)T >= c) {
			double avgD = totEdges/S;
			// Calculate out degree of each vertex
			for(pii e : H) {
				if(inS[e.first] == 0 && inT[e.second] == 0)
					outDeg[e.first]++;
			}

			// Peeling
			for(int i = 0; i < n; i++) {
				if(inS[i] == 0 && outDeg[i] <= (1+ep)*avgD) {
					// Remove from set S
					inS[i] = 1;
					S--;
					totEdges -= outDeg[i];
				}
			}

			// Clear out degree for next iteration
			for(int i = 0; i < n; i++)
				outDeg[i] = 0;
		}
		else {
			double avgD = totEdges/T;
			// Calculate in degree of each vertex
			for(pii e : H) {
				if(inS[e.first] == 0 && inT[e.second] == 0)
					inDeg[e.second]++;
			}

			// Peeling
			for(int i = 0; i < n; i++) {
				if(inT[i] == 0 && inDeg[i] <= (1+ep)*avgD) {
					// Remove from set T
					inT[i] = 1;
					T--;
					totEdges -= inDeg[i];
				}
			}

			// Clear out degree for next iteration
			for(int i = 0; i < n; i++)
				inDeg[i] = 0;
		}

		// Update best density
		totEdges = 0;
		for(pii e : H) {
			if(inS[e.first] == 0 && inT[e.second] == 0)
				totEdges++;
		}
		if(S != 0 && T != 0) {
			// Calculate approximate density
			double currD = totEdges/sqrt(S*T) * (1/p);
			if(currD > bestD) {
				bestD = currD;
				for(int i = 0; i < n; i++) {
					if(inS[i] == 0) bestS[i] = 0;
					else bestS[i] = 1;
					if(inT[i] == 0) bestT[i] = 0;
					else bestT[i] = 1;
				}
			}
		}
	}
	// Calculate actual density
	totEdges = 0;
	S = 0;
	T = 0;
	for(int i = 0; i < n; i++) {
		if(bestS[i] == 0) S++;
		if(bestT[i] == 0) T++;
	}
	for(pii e : full_stream) {
		if(bestS[e.first] == 0 && bestT[e.second] == 0)
			totEdges++;
	}
	bestD = totEdges/sqrt(S*T);
	return bestD;
}

void runDS(int z) {
	string name = dataset[z];
	cout << name << ":" << endl;
	ifstream data(name + ".txt");
	full_stream.clear();

	int n = vertices[z];

	// Construct graph
	int x;
    while(data >> x) {
    	int y; data >> y;
    	full_stream.push_back(pii(x, y));
    }

    double ep = 0.2;
    double c = 1/(double)n;
    double delta = 1+ep;

    // Run MP24
    ofstream ourData("mp24data-" + name + "-time.txt");
    double ourDensity = 0;
    c = 1/(double)n;
    while(c <= n) {
    	cout << "c: " << c << '\n';
    	curr = 0;
    	auto start=high_resolution_clock::now();
    	double val = ourAlg(c, ep, 450, n);
    	auto stop=high_resolution_clock::now();
    	auto duration= duration_cast<microseconds>(stop - start);
    	cout << "our density: " << val << " " << duration.count() << '\n';
    	//ourData<<c<<" "<<val<<" "<<duration.count()<<'\n';
    	for(ll i = 0; i < durations.size(); i++) {
    		ourData << (ll)10000*(i+1) << " " << durations[i] << '\n';
    	}
    	ourDensity = max(ourDensity, val);
    	for(int i = 0; i < n; i++) {
    		inS[i] = 0;
    		inT[i] = 0;
    	}
    	durations.clear();
    	c *= delta;
    }
    //cout << "best Bahmani Density: " << bahmaniDensity << '\n';
    cout << "best Our Density: " << ourDensity << '\n';
}

int main() {
	ios_base::sync_with_stdio(0);
    cin.tie(NULL);
    
    //runDS(1);
    for(int i = 0; i < 5; i++) {
    	runDS(i);
    }
}
